/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.rules;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskNumericProperty;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskPropertyPanel;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.VWTaskTabbedPane;
import filenet.vw.apps.taskman.rules.VWRulesNode;
import filenet.vw.apps.taskman.rules.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class VWRulesPropertyPanel
extends VWTaskPropertyPanel {
    VWRulesNode m_node = null;
    VWTaskTabbedPane m_tabbedPane = null;
    JLabel m_iconLabel = null;
    VWTaskNumericProperty m_port = null;
    JTextField m_propertyFile = null;
    JTextField m_javaArgs = null;
    JTextArea m_classPath = null;

    public VWRulesPropertyPanel(VWRulesNode rulesNode) throws Exception {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.m_node = rulesNode;
        this.addTabbedPane();
        this.refresh();
        this.m_tabbedPane.addVWTaskPropertyChangedListener(this);
    }

    public void refresh() {
        try {
            if (!this.m_node.isDirty()) {
                this.resetProperties();
            }
            boolean stopped = !this.m_node.isStarted();
            this.m_iconLabel.setIcon(this.m_node.getIcon32());
            this.m_port.setEditable(stopped);
        }
        catch (Exception e) {
            this.m_node.displayError(e);
        }
    }

    public String getPort() {
        return this.m_port.getText().trim();
    }

    private void addTabbedPane() {
        this.m_tabbedPane = new VWTaskTabbedPane();
        this.m_tabbedPane.addTab(filenet.vw.apps.taskman.resources.VWResource.General, this.getGeneralPanel());
        this.add((Component)this.m_tabbedPane, "Center");
    }

    private VWTaskTabPanel getGeneralPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 23;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(4, 10, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this.m_iconLabel = new JLabel(this.m_node.getIcon32(), 2);
        panel.add((Component)this.m_iconLabel, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridy = 0;
        c.gridx = 1;
        c.insets = new Insets(9, 10, 0, 0);
        c.gridwidth = 0;
        panel.add((Component)new JLabel(VWResource.RulesEngine), c);
        c.gridy = 1;
        c.gridx = 0;
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(30, 0, 0, 0);
        panel.add((Component)this.getGeneralSettingsPanel(), c);
        return panel;
    }

    public VWTaskTabPanel getGeneralSettingsPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets = new Insets(10, 10, 0, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_port = new VWTaskNumericProperty("");
        this.m_port.setName(VWResource.Port);
        panel.add((Component)new JLabel(this.m_port.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_port, (Object)c, true);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_propertyFile = new JTextField("");
        this.m_propertyFile.setName(VWResource.PropertyFile);
        panel.add((Component)new JLabel(this.m_propertyFile.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_propertyFile, (Object)c, true);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_javaArgs = new JTextField("");
        this.m_javaArgs.setName(VWResource.JREParameters);
        panel.add((Component)new JLabel(this.m_javaArgs.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_javaArgs, (Object)c, false);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_classPath = new JTextArea();
        this.m_classPath.setRows(4);
        this.m_classPath.setLineWrap(true);
        this.m_classPath.setName(VWResource.Classpath);
        panel.add((Component)new JLabel(this.m_classPath.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((Component)new JScrollPane(this.m_classPath, 20, 31), c);
        c.insets = new Insets(0, 0, 5, 0);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        panel.add(Box.createHorizontalStrut(1), c);
        return panel;
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.APPLY) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.OK) == 0) {
                if (this.validateProperties()) {
                    this.applyProperties();
                }
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.RESET) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.CANCEL) == 0) {
                this.resetProperties();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.m_node.displayHelp();
            }
        }
        catch (Exception ex) {
            this.m_node.displayError(ex);
        }
    }

    public void applyProperties() throws Exception {
        this.m_node.setPortNumber(Integer.parseInt(this.m_port.getText().trim()));
        this.m_node.setPropertyFile(this.m_propertyFile.getText());
        this.m_node.setJavaArgs(this.m_javaArgs.getText());
        this.m_node.setClassPath(this.m_classPath.getText());
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 1));
    }

    public void resetProperties() throws Exception {
        this.m_port.setText("" + this.m_node.getPortNumber());
        this.m_propertyFile.setText(this.m_node.getPropertyFile());
        this.m_javaArgs.setText(this.m_node.getJavaArgs());
        this.m_classPath.setText(this.m_node.getClassPath());
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 2));
    }

    private boolean validateProperties() {
        try {
            this.m_tabbedPane.validateProperties();
        }
        catch (VWException e) {
            this.m_node.displayError(e);
            return false;
        }
        return true;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   13 Feb 2009 17:39:56  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.4  $";
    }
}

